# Инструкция по использованию скрипта для копирования сайта

## Описание

Этот набор скриптов позволяет:

* **скопировать одну страницу** или **весь сайт** (HTML, CSS, JS, изображения);
* **автоматически создать Docker-проект** с Nginx;
* **локально запустить копию сайта** через Docker.

---

## Требования

Перед началом убедитесь, что установлены:

1. **Python 3.10+**

   ```bash
   python --version
   ```

2. **pip** — менеджер пакетов Python

   ```bash
   pip --version
   ```

3. **Firefox** (браузер, необходимый для Selenium)

4. **Docker и Docker Compose**

   ```bash
   docker --version
   docker compose version
   ```

---

## Установка и подготовка окружения

1. **Создайте виртуальное окружение (venv)**
   В терминале, находясь в папке с проектом, выполните:

   ```bash
   python -m venv venv
   ```

2. **Активируйте окружение**

   * **Windows:**

     ```bash
     venv\Scripts\activate
     ```
   * **macOS / Linux:**

     ```bash
     source venv/bin/activate
     ```
     Если возникает ошибка, попробуйте с sudo

3. **Установите зависимости**

   ```bash
   pip install -r requirements.txt
   ```

---

## Как использовать

### Вариант 1: Скопировать одну страницу

1. Запустите:

   ```bash
   python app.py
   ```

2. Введите данные:

   ```
   Введите ссылку на страницу: https://example.com/about
   Введите название страницы: about
   ```

3. Программа создаст структуру проекта и скачает страницу в:

   ```
   example.com/public/about.html
   ```

4. После завершения появится сообщение:

   ```
   Копирование сайта завершено.
   ```

---

### Вариант 2: Скопировать весь сайт

1. Запустите:

   ```bash
   python app-full.py
   ```

2. Введите ссылку на сайт:

   ```
   https://example.com
   ```

3. Скрипт автоматически:

   * создаст папку проекта;
   * скачает все страницы, скрипты, стили и изображения;
   * создаст Docker-конфигурацию.

4. После завершения появится сообщение:

   ```
   Копирование сайта завершено.
   ```

---

## Правка Nginx перед запуском Docker

После завершения копирования сайта **откройте файл:**

```
<имя_сайта>/docker/nginx/sites-enabled/default.conf
```

В этом файле нужно **вручную прописать все страницы**, чтобы Nginx мог их отдавать.

Пример для сайта с главной страницей (`index`) и страницей `about`:

```nginx
server {
    listen        80;

    access_log    /dev/stdout combined;
    error_log     /dev/stdout error;

    root          /srv/www;
    index         index.html;

    error_page    404 /404.html;

    location / {
        try_files $uri $uri/ /index.html;
    }

    location /about {
        try_files $uri $uri/ /about.html;
    }

    location ~* \.(js|jpg|png|css|svg|woff2|json|otf|ttf|ico)$ {
        root /srv/www;
        add_header Cache-Control "public";
    }
}
```

> 💡 Если страниц несколько (`/services`, `/contact`, `/portfolio` и т.д.) — добавьте для каждой аналогичный блок `location`.

---

## Запуск сайта через Docker

1. Перейдите в созданную папку сайта:

   ```bash
   cd example.com
   ```

2. Соберите контейнер:

   ```bash
   docker compose build
   ```

3. Запустите сайт:

   ```bash
   docker compose up
   ```

4. В браузере откройте:

   ```
   http://localhost:<ваш_порт>
   ```

   > Во время работы скрипта программа спросит порт (например, `8080`).

---

## Остановка и очистка

Остановить контейнер:

```bash
docker compose down
```

Удалить ненужные контейнеры и кэш:

```bash
docker system prune -a
```

---

## Где искать результат

Все скачанные файлы сайта находятся в:

```
<домен>/public/
```

Пример:

```
example.com/public/
├── index.html
├── about.html
├── static/
│   ├── css/
│   └── js/
└── images/
```